<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('transactionable_id');
            $table->string('transactionable_type');
            $table->decimal('amount', 10, 2);
            $table->decimal('fee', 10, 2);
            $table->string('dr_cr');
            $table->string('type');
            $table->string('method');
            $table->dateTime('date');
            $table->string('created_user_id')->nullable();
            $table->string('note')->nullable();
            $table->string('transaction_details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};